<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{$title_view}}</title>

    <style>

        @font-face {
           font-family: rft;
           src: url('{{ public_path('fonts/urw_italic.ttf') }}');
           font-style: 'Extra Bold';
           font-weight: '800';
        }
        @font-face {
           font-family: chancur;
           src: url('{{ public_path('fonts/chancur.ttf') }}');
           font-style: 'Extra Bold';
           font-weight: '800';
        }

        body{
            /*font-family: Tahoma, Geneva, sans-serif;*/
        }


        .borderimg{
            position: fixed;
            top: 0;
            left: 0;

            /* Preserve aspet ratio */
            /*min-width: 100%;*/
            /*min-height: 100%;*/
        }

        .main-div {

            @if ($setting_list->watermark_status)
                background-image: url({{asset("/img/site/testimonial").'/'.$setting_list->watermark_image}});
                background-position: center center;
                background-size: cover;
                background-repeat: no-repeat;
            @endif


            background-color: {{$setting_list->testimonial_background_color?$setting_list->testimonial_background_color:'white'}};


    }

        .name-style{
            font-weight: bold;
            text-align: center;
            border-bottom: 1px dotted black;
            display: inline-block;
            overflow:hidden;
            font-family: rft;
            text-transform: capitalize;
            font-size: 20px;
        }

        .district{
            font-weight: bold;
            text-align: center;
            border-bottom: 1px dotted black;
            display: inline-block;
            overflow:hidden;
            text-transform:uppercase;
        }
        .thana{
            font-weight: bold;
            text-align: center;
            border-bottom: 1px dotted black;
            display: inline-block;
            overflow:hidden;
            text-transform:uppercase;
        }

        .rollreg{
            font-weight: bold;
            text-align: center;
            border-bottom: 1px dotted black;
            display: inline-block;
            overflow:hidden;
            text-transform:uppercase;
            
            
        }
        .birth_date{
            font-size: 18px;
            font-weight: bold;
            font-family: rft;
        }

        /*.exam-center{*/
            /*font-weight: bold;*/
            /*width: 80px;*/
            /*text-align: center;*/
            /*border-bottom: 1px dotted black;*/
            /*display: inline-block;*/
            /*overflow:hidden;*/
            /*text-transform:uppercase;*/
        /*}*/

        .details-text tr td{
            /*display: inline-block;*/
            text-align:justify;
            line-height:2;
        }

    </style>

</head>
<body>

<div>
    <div style="display: none;">
        <?php
        echo $size=sizeof($student_detail);
        ?>
    </div>

    @foreach($student_detail as $key=>$item)
        <div class="" >
            @if ($setting_list->border_image_status)
                <img class="borderimg" src="{{asset('/img/site/testimonial').'/'.$setting_list->border_image}}" width="1056" height="720">
            @endif
            <div class="main-div" style="padding: 70px;height: 500px;">

                <div style="text-align: center;">
                    <table width="100%;" border="0">
                        <tr>
                            <td style="width: 15%;">
                                @if($setting_list->logo_position=='left')
                                    <img style="float: left;padding: 0;" src="{{asset($site->site_logo)}}" width="90" height="85">
                                @endif
                            </td>
                            <td style="width: 70%; text-align: center; /*border: 1px solid green*/;">
                                <div class="sitename" style="font-size: 30px;text-transform:uppercase; font-weight:bold; font-style: {{$setting_list->academic_name_font}}">{!! $site->site_name !!}</div>
                                <div style="font-size: 15px; font-style: {{$setting_list->academic_address_font}}">{!! $site->address !!}</div>
                            </td>
                            <td style="width: 15%;font-size: 10px;text-align: right;vertical-align: bottom;">
                                @if($setting_list->eiin_show_status)
                                <div style="font-size: 14px;"> EIIN: {!! $site->eiin !!}</div>
                                @endif
                                @if($setting_list->college_code_show_status)
                                <div style="font-size: 14px;"> College Code: {!! $site->college_code !!}</div>
                                @endif
                                @if($setting_list->nu_code_show_status)
                                <div style="font-size: 14px;"> NU Code: {!! $site->nu_code !!}</div>
                                @endif

                            </td>
                        </tr>
                    </table>
                </div>


                @if($setting_list->logo_position=='center')
                    <div style="text-align: center;">
                        <img style="padding: 0;" src="{{asset($site->site_logo)}}" width="90" height="85">
                    </div>
                    <div style="margin-top:10px;">

                        <div style="text-align:center; font-style: {{$setting_list->title_font}}">
                            <label class="tittle" style="font-size: 19px;text-transform:uppercase;">
                                <span>{!! $report_tittle !!}</span>
                            </label>
                        </div>

                        <div style="font-style:{{$setting_list->ref_no_font}}">
                            <span>
                                Ref. No.:
                                <b>{{$item->SiteManuallyTestimonial->referance_prefix}}</b>
                                <b>{{$item->SiteManuallyTestimonial->referance_number}}</b>
                                <b>{{$item->SiteManuallyTestimonial->referance_suffix}}</b>
                            </span>
                        </div>

                    </div>
                @endif

                @if($setting_list->logo_position=='left')
                    <div style="margin-top:20px;">

                        <div style="margin-top:30px;text-align:center; font-style: {{$setting_list->title_font}}">
                            <label class="tittle" style="font-size: 19px;text-transform:uppercase;">
                                <span>{!! $report_tittle !!}</span>
                            </label>
                        </div>

                        <div style="font-style:{{$setting_list->ref_no_font}}">
                            <span>
                                Ref. No.:

                                <b>{{$item->SiteManuallyTestimonial->referance_prefix}}</b>
                                <b>{{$item->SiteManuallyTestimonial->referance_number}}</b>
                                <b>{{$item->SiteManuallyTestimonial->referance_suffix}}</b>
                            </span>
                        </div>

                    </div>
                @endif

                <div style="margin-top:10px;font-size:16px; width: 900px; font-style:{{$setting_list->description_font}}">
                    <table class="details-text" width="100%;" border="0">
                        <tr>
                            <td style="width: 100%;">

                                {{-- This is to certify that --}}
                                {{$setting_list->des_part_1}}
                                <span class="name-style" style="width: 700px;">
                                    {{$item->full_name}}
                                </span>,
                                <br>

                                @if($item->student->gender->head_key=='girls')
                                    <span>Daughter of</span>
                                @elseif($item->student->gender->head_key=='boys')
                                    <span>son of</span>

                                @endif

                                <span class="name-style" style="width: 400px;">
                                    {{$item->student->father_name}}
                                </span>
                                
                                and
                                <span class="name-style" style="width: 400px;">
                                    {{$item->student->mother_name}}
                                </span>
                                 <br>

                                @if ($setting_list->address_present_status)
                                   
                                    @if($item->student->permanentThana)
                                    Village/Thana&nbsp;
                                        <span>{{$item->student->permanentThana->thana_name}}</span>,
                                    @endif
                              
                                    @if($item->student->permanentDistrict)
                                    District&nbsp;
                                        <span>{{$item->student->permanentDistrict->district_name}}</span>
                                    @endif

                                @endif
                                
                                was a student of
                                {!! $site->site_name !!} 
                                @if ($setting_list->session_show_status)
                                
                                @if ($item->session)
                                in the session
                                    <span><b>{{$item->session->session_name}}.</b></span>
                                @else
                                    <span><b>.</b></span>
                                @endif
                            @endif

                            @if($item->student->gender->head_key=='girls')
                            <span>She</span>
                            @elseif($item->student->gender->head_key=='boys')
                                <span>He</span>
                            @endif
                        
                             passed
                                {{-- @if($item->SiteManuallyTestimonial->pass_fail_status)
                                    <b>Passed</b>
                                @else
                                    <b>Failed</b>
                                @endif --}}
                                {{-- <br> --}}

                                the 
                                <b>{{$item->SiteManuallyTestimonial->academicResultPrimaryType->name}}</b>
                                in
                                @if($item->SiteManuallyTestimonial->passing_year)
                                    <b>{{$item->SiteManuallyTestimonial->passing_year}}</b>
                                @else
                                    <b>{{$item->year->year_name}}</b>
                                @endif

                                {{-- from this Institution under the --}}
                                {{$setting_list->des_part_2}}

                                @if($site->academicBoard)
                                <b>{{$site->academicBoard->name}}</b> 
                                @endif
                                 @if($item->classGroup)
                                    in <b>science</b> group.
                                @else
                                    <span>.</span>
                                @endif
                              
                                {{-- @if ($setting_list->session_show_status)
                                    & Session
                                    @if ($item->session)
                                        <span><b>{{$item->session->session_name}}.</b></span>
                                    @else
                                        <span><b>.</b></span>
                                    @endif
                                @endif --}}

                                @if($item->student->gender->head_key=='girls')
                                    <span>She</span>
                                @elseif($item->student->gender->head_key=='boys')
                                    <span>He</span>
                                @endif
                                
                                obtained
                                GPA
                                <b>{{number_format($item->SiteManuallyTestimonial->gpa, 2, '.', ',')}}</b>
                                {{-- <b>({{$item->SiteManuallyTestimonial->academicResultSystem->name}})</b>--}}.
                                @if($item->student->gender->head_key=='girls')
                                <span>Her</span>
                                @elseif($item->student->gender->head_key=='boys')
                                    <span>His</span>
                                @endif

                                @if($item->board_roll_number)
                                 roll no. 
                                is <span style="font-weight: 900;">{{$item->board_roll_number}}</span>,
                                @endif
                                @if (!$setting_list->session_show_status)
                               and
                                @endif
                                @if($item->board_registration_number)           
                                    registration no. is
                                    <span style="font-weight: 900;">{{$item->board_registration_number}}.</span>
                                @endif 
                                {{-- @if($item->classGroup)
                                    <b>in {{$item->classGroup->group_name}} group.</b>
                                @else
                                    <span>.</span>
                                @endif --}}

                                {{-- According to the record --}}
                                {{$setting_list->des_part_4}}
                                @if($item->student->gender->head_key=='girls')
                                    <span>her</span>
                                @elseif($item->student->gender->head_key=='boys')
                                    <span>his</span>
                                @endif
                                date of birth 
                                is<span class='birth_date'>
                                 {{date('d M Y', strtotime($item->student->date_of_birth))}}
                                </span>

                            </td>
                        </tr>


                        <tr>
                            <td>

                                {{-- To the best of my knowledge, --}}
                                {{$setting_list->des_part_6}}

                                @if($item->student->gender->head_key=='girls')
                                    <span>she</span>
                                @elseif($item->student->gender->head_key=='boys')
                                    <span>he</span>
                                @endif
                                {{-- did not take part in any activities subversive of the state or discipline. --}}
                                   
                                    {{$setting_list->des_part_7}}

                                    {{-- @if($item->student->gender->head_key=='girls')
                                        <span>Her</span>
                                    @elseif($item->student->gender->head_key=='boys')
                                        <span>His</span>
                                    @endif --}}

                                    {{-- conduct and character is good. --}}
                                    {{$setting_list->des_part_8}}
                                <br>

                                I wish
                                @if($item->student->gender->head_key=='girls')
                                    <span>her</span>
                                @elseif($item->student->gender->head_key=='boys')
                                    <span>him</span>
                                @endif
                                {{-- every success in life. --}}
                                {{$setting_list->des_part_9}}
                            </td>
                        </tr>
                    </table>

                    <!-- His Date of Birth is
                    <label>1/1/2020</label> -->

                </div>

                @if($setting_list->logo_position=='left')
                    <br>
                @endif

                <div style="margin-top:15px;font-size:14px;">
                    <table width="100%" >
                        <tr>
                            <td style="text-align:left; font-style:{{$setting_list->print_data_font}}" width="70%">
                                <br><br>
                                Date: ___/___/______
                                
                            </td>

                            <td style="float: right;text-align:center;padding-right:20px; font-style:{{$setting_list->author_font}}"  width="50%">
                                <span>..............................</span><br>
                                <span>{{$designation}}</span><br>
                                <span>{!! $site->site_name !!}</span> <br>
                                <span style="font-size:11px;">{!! $site->address !!}</span>
                            </td>
                        </tr>
                    </table>

                </div>

            </div>
        </div>
  {{-- @if ($setting_list->exam_center_show_status)
                                    <b>{{$setting_list->exam_center}}</b>&nbsp;
                                    <span><b>{{$setting_list->exam_center_code}}</b></span>
                                @endif --}}
        {{--<div style="page-break-after: always;page-break-inside:avoid;"></div>--}}
        @if($size>$key+1)
        <div style="page-break-after: always;page-break-inside:avoid;"></div>
    @endif
    @endforeach

</div>

</body>


<style>
    @page {
        /* size: Landscape; */
        size:1056px 720px;
        margin: 1px 0;
    }

    /*@page {*/
    /*size: a4;*/
    /*margin: 1px 0;*/
    /*}*/
    body {
        /* margin: 10px 15px 10px 20px; */
        margin: 0px 0px 0px 0px;

    }
    


</style>
{{-- Printed On: {{date('d M Y',time())}} --}}

</html>